/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_AD_User;
import org.compiere.model.X_AD_WF_Responsible;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFResponsible;

@Process
public class WFActivityManage
extends SvrProcess {
    private boolean p_IsAbort = false;
    private int p_AD_User_ID = 0;
    private int p_AD_WF_Responsible_ID = 0;
    private int p_AD_WF_Activity_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("IsAbort")) {
                    this.p_IsAbort = "Y".equals(para[i2].getParameter());
                } else if (name.equals("AD_User_ID")) {
                    this.p_AD_User_ID = para[i2].getParameterAsInt();
                } else if (name.equals("AD_WF_Responsible_ID")) {
                    this.p_AD_WF_Responsible_ID = para[i2].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
                }
            }
            ++i2;
        }
        this.p_AD_WF_Activity_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        PO to;
        PO from;
        MWFActivity activity = new MWFActivity(this.getCtx(), this.p_AD_WF_Activity_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - " + String.valueOf(activity));
        }
        MUser user = MUser.get(this.getCtx(), this.getAD_User_ID());
        if (this.p_IsAbort) {
            String msg = user.getName() + ": Abort";
            activity.setTextMsgBefore(msg);
            activity.setAD_User_ID(this.getAD_User_ID());
            activity.setProcessed(true);
            activity.setWFState("CA");
            activity.saveEx();
            return msg;
        }
        String msg = null;
        if (this.p_AD_User_ID != 0 && activity.getAD_User_ID() != this.p_AD_User_ID) {
            from = MUser.get(this.getCtx(), activity.getAD_User_ID());
            to = MUser.get(this.getCtx(), this.p_AD_User_ID);
            msg = user.getName() + ": " + ((X_AD_User)from).getName() + " -> " + ((X_AD_User)to).getName();
            activity.setTextMsg(msg);
            activity.setAD_User_ID(this.p_AD_User_ID);
        }
        if (this.p_AD_WF_Responsible_ID != 0 && activity.getAD_WF_Responsible_ID() != this.p_AD_WF_Responsible_ID) {
            from = MWFResponsible.get(this.getCtx(), activity.getAD_WF_Responsible_ID());
            to = MWFResponsible.get(this.getCtx(), this.p_AD_WF_Responsible_ID);
            String msg1 = user.getName() + ": " + ((X_AD_WF_Responsible)from).getName() + " -> " + ((X_AD_WF_Responsible)to).getName();
            activity.setTextMsg(msg1);
            activity.setAD_WF_Responsible_ID(this.p_AD_WF_Responsible_ID);
            msg = msg == null ? msg1 : msg + " - " + msg1;
        }
        activity.saveEx();
        return msg;
    }
}

